/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.ast;

import com.inprise.vbroker.compiler.ast.ContainedContainerNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.backends.depsolver.DepSolverDefs;
import com.inprise.vbroker.compiler.util.QName;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class InheritableNode
extends ContainedContainerNode
implements Type,
DepSolverDefs {
    public boolean _idlEntity = true;
    public boolean _abstract;
    public boolean _pseudo;
    public boolean _defined;
    public Vector _bases = new Vector();
    public Vector _allBases;
    public Vector _allContents;
    public Hashtable _bindings;
    public transient ContainedNode[] _beMethods;
    public transient ContainedNode[] _beAllMethods;

    public InheritableNode(int kind) {
        super(kind);
    }

    public void addBase(InheritableNode base) {
        if (this._bases.contains(base)) {
            if (base != InterfaceNode.ERROR && base != ValueNode.ERROR) {
                this.error("Comp.AST.duplicateBase", base._name);
            }
        } else {
            this._bases.addElement(base);
        }
    }

    public void cache() {
        this._allBases = new Vector();
        InheritableNode.recGenBases(this, this._allBases);
        this.genAllContents();
        this.genBindings();
    }

    public Node define(int type, String name, String repId, String version, String comment) {
        ContainedNode ret = Node.define(type, name, this, repId, version, comment, this._contents);
        if (ret != null) {
            ContainedNode conflicter;
            this._allContents.addElement(ret);
            String canonicalName = name.toLowerCase();
            if (!(ret._kind != 7 && ret._kind != 2 && ret._kind != 22 || (conflicter = (ContainedNode)this._bindings.get(canonicalName)) == null || conflicter._kind != 7 && conflicter._kind != 2 && conflicter._kind != 22)) {
                String ctype;
                String string = ret._kind == 7 ? "operation" : (ctype = ret._kind == 2 ? "attribute" : "value member");
                String mesg = conflicter._kind == 7 ? "Comp.AST.collisionWithInheritedOperation" : (conflicter._kind == 2 ? "Comp.AST.collisionWithInheritedAttribute" : "Comp.AST.collisionWithInheritedValueMember");
                this.error(mesg, new Object[]{name, ctype, this._repository._ER.getFileName(conflicter._fileNumber), new Long(conflicter._lineNumber)});
            }
            this._bindings.put(canonicalName, ret);
        }
        return ret;
    }

    public Vector find(String name, int depth, int type, boolean excludeInherited) {
        if (excludeInherited) {
            return Node.find(this._contents, name, depth, type, excludeInherited);
        }
        return Node.find(this._allContents, name, depth, type, excludeInherited);
    }

    public boolean finish(int code) {
        super.finish(code);
        if (this._beMethods == null) {
            ContainedNode c;
            int i;
            if (!this._defined) {
                this.cache();
            }
            if (!this._defined && this._repository._options._warnMissingDefine) {
                String fileName = this._repository._ER.getFileName(this._fileNumber);
                this._repository._ER.warn("Comp.AST.declOnly", new Object[]{this._fullName, fileName, new Long(this._lineNumber)});
                this._repository._ER.warnAdd("Comp.AST.NoCodeGen");
            }
            int len = this._contents.size();
            ContainedNode[] methods = new ContainedNode[len];
            int index = 0;
            for (i = 0; i < len; ++i) {
                c = (ContainedNode)this._contents.elementAt(i);
                if (c._kind != 7 && c._kind != 2) continue;
                methods[index++] = c;
            }
            this._beMethods = new ContainedNode[index];
            System.arraycopy(methods, 0, this._beMethods, 0, index);
            len = this._allContents.size();
            methods = new ContainedNode[len];
            index = 0;
            for (i = 0; i < len; ++i) {
                c = (ContainedNode)this._allContents.elementAt(i);
                if (c._kind != 7 && c._kind != 2) continue;
                methods[index++] = c;
            }
            this._beAllMethods = new ContainedNode[index];
            System.arraycopy(methods, 0, this._beAllMethods, 0, index);
        }
        return true;
    }

    protected void genAllContents() {
        this._allContents = new Vector();
        int len = this._contents.size();
        this._allContents.ensureCapacity(len);
        for (int j = 0; j < len; ++j) {
            this._allContents.addElement(this._contents.elementAt(j));
        }
        int size = this._allBases.size();
        for (int i = 0; i < size; ++i) {
            Vector v = ((InheritableNode)this._allBases.elementAt((int)i))._contents;
            int l = v.size();
            this._allContents.ensureCapacity(l);
            for (int j = 0; j < l; ++j) {
                this._allContents.addElement(v.elementAt(j));
            }
        }
    }

    protected void genBindings() {
        int i;
        this._bindings = new Hashtable();
        Vector<String> ambigNames = new Vector<String>();
        int size = this._allBases.size();
        for (i = 0; i < size; ++i) {
            Vector v = ((InheritableNode)this._allBases.elementAt((int)i))._contents;
            int len = v.size();
            for (int j = 0; j < len; ++j) {
                ContainedNode elem = (ContainedNode)v.elementAt(j);
                String canonicalName = elem._name.toLowerCase();
                ContainedNode formerDef = (ContainedNode)this._bindings.get(canonicalName);
                if (formerDef != null && formerDef != elem) {
                    ambigNames.addElement(canonicalName);
                    if (elem._kind == 7) {
                        this.error("Comp.AST.inheritedOperationCollision", new Object[]{elem._name, this._repository._ER.getFileName(elem._fileNumber), new Long(elem._lineNumber), this._repository._ER.getFileName(formerDef._fileNumber), new Long(formerDef._lineNumber)});
                        continue;
                    }
                    if (elem._kind != 2) continue;
                    this.error("Comp.AST.inheritedAttributeCollision", new Object[]{elem._name, this._repository._ER.getFileName(elem._fileNumber), new Long(elem._lineNumber), this._repository._ER.getFileName(formerDef._fileNumber), new Long(formerDef._lineNumber)});
                    continue;
                }
                this._bindings.put(canonicalName, elem);
            }
        }
        int len = ambigNames.size();
        for (i = 0; i < len; ++i) {
            this._bindings.remove(ambigNames.elementAt(i));
        }
        len = this._contents.size();
        for (int j = 0; j < len; ++j) {
            ContainedNode elem = (ContainedNode)this._contents.elementAt(j);
            String canonicalName = elem._name.toLowerCase();
            this._bindings.put(canonicalName, elem);
        }
    }

    public Vector getGoodBases(int kind) {
        InheritableNode base;
        int i;
        Hashtable<InheritableNode, Boolean> badAbstracts = new Hashtable<InheritableNode, Boolean>();
        Vector<InheritableNode> goodBases = new Vector<InheritableNode>();
        int len = this._bases.size();
        for (i = 0; i < len; ++i) {
            base = (InheritableNode)this._bases.elementAt(i);
            int len1 = base._allBases.size();
            for (int j = 0; j < len1; ++j) {
                InheritableNode node = (InheritableNode)base._allBases.elementAt(j);
                if (!node._abstract) continue;
                badAbstracts.put(node, Boolean.TRUE);
            }
        }
        for (i = 0; i < len; ++i) {
            base = (InheritableNode)this._bases.elementAt(i);
            if (base._abstract && badAbstracts.containsKey(base) || kind >= 0 && kind != base._kind) continue;
            goodBases.addElement(base);
        }
        return goodBases;
    }

    public ContainedNode lookup(QName qname, boolean local) {
        String canonicalName = qname._s.toLowerCase();
        ContainedNode def = (ContainedNode)this._bindings.get(canonicalName);
        if (def == null) {
            return local ? null : this._container.lookup(qname, false);
        }
        if (def._name != null && !def._name.equals(qname._s)) {
            def.warnCaseViolation(qname._s);
        }
        if (qname._next == null) {
            return def;
        }
        if (def.isContainer()) {
            return ((ContainerNode)((Object)def)).lookup(qname._next, true);
        }
        return null;
    }

    public ContainedNode lookup(String name, boolean local) {
        String canonicalName = name.toLowerCase();
        ContainedNode def = (ContainedNode)this._bindings.get(canonicalName);
        if (def == null) {
            if (local) {
                return null;
            }
            if (this._container == null) {
                return null;
            }
            return this._container.lookup(name, false);
        }
        return def;
    }

    protected static final void recGenBases(InheritableNode n, Vector bases) {
        int size = n._bases.size();
        for (int i = 0; i < size; ++i) {
            InheritableNode base = (InheritableNode)n._bases.elementAt(i);
            if (!bases.contains(base)) {
                bases.addElement(base);
            }
            InheritableNode.recGenBases(base, bases);
        }
    }

    public void validateBases() {
        if (!this._pseudo) {
            Enumeration e = this._bases.elements();
            while (e.hasMoreElements()) {
                InheritableNode base = (InheritableNode)e.nextElement();
                if (base == InterfaceNode.ERROR || base == ValueNode.ERROR || this._pseudo || !base._pseudo) continue;
                this.error("Comp.AST.pseudoBaseForRegular", base._name);
            }
        }
    }
}

